
<?php get_header(); ?>


<?php if( have_rows('product') ): ?>
  <div class="container">
    <ul class="product-menu">
      <?php while ( have_rows('product') ) : the_row(); ?>
        <?php if( get_row_layout() == 'product_single' ): ?>
          <?php
            $product_section_label=get_sub_field('product_section_label');
          ?>
          <li data-aos-delay="<?php echo get_row_index(); ?>00" data-aos="fade-up"><a class="btn-primary" href="#product-<?php echo get_row_index(); ?>"><?php echo $product_section_label; ?></a></li>
        <?php endif; ?>

      <?php endwhile; ?>
    </ul>
  </div>
<?php endif; ?>
<?php wp_reset_postdata(); ?>


<?php if( have_rows('product') ): ?>
  <?php while ( have_rows('product') ) : the_row(); ?>
    <?php if( get_row_layout() == 'product_single' ): ?>
      <?php
        $product_name=get_sub_field('product_name');
        $product_section_label=get_sub_field('product_section_label');
      ?>
      <section class="product" id="product-<?php echo get_row_index(); ?>">
        <div class="container">
          <div class="row">
            <div class="col-12 col-md-6">
              <div class="product-left">
                <h2 data-aos="fade-left"><?php the_title(); ?></h2>
                <?php if( $product_name ) { ?>
                  <h3 data-aos-delay="300" data-aos="fade-left"><?php echo $product_name; ?></h3>
                <?php } ?>
              </div>
            </div>
          </div>

          <div class="row">
            <div class="col-12 col-md-6">
              <div class="product-left">   
                <?php if( have_rows('sections_left_section') ): ?>
                  <?php while ( have_rows('sections_left_section') ) : the_row(); ?>
                    <?php if( get_row_layout() == 'sections_left_section_image' ): ?>
                      <?php
                        $sections_left_image=get_sub_field('sections_left_image');
                      ?>
                      <?php if( $sections_left_image ) { ?>
                        <div data-aos-delay="300" data-aos="fade-right"><img class="lazy product-img" data-src="<?php echo $sections_left_image; ?>" alt="" /></div>
                      <?php } ?>
                    <?php endif; ?>
                    <?php if( get_row_layout() == 'sections_left_section_content' ): ?>
                      <?php
                        $sections_left_content=get_sub_field('sections_left_content');
                      ?>
                      <?php if( $sections_left_content ) { ?>
                        <div class="product-content" data-aos-delay="300" data-aos="fade-right">><?php echo $sections_left_content; ?></div>
                      <?php } ?>
                    <?php endif; ?>
                    <?php if( get_row_layout() == 'sections_left_section_attributes' ): ?>
                      <?php if( have_rows('sections_left_attributes') ): ?>
                        <div class="row product-attributes">
                          <?php while ( have_rows('sections_left_attributes') ) : the_row(); ?>
                            <?php
                              $sections_left_attributes_ico=get_sub_field('sections_left_attributes_ico');
                              $sections_left_attributes_name=get_sub_field('sections_left_attributes_name');
                              $sections_left_attributes_description=get_sub_field('sections_left_attributes_description');
                            ?>
                            <div class="col-6 col-lg-4">
                              <div class="product-attributes-box" data-aos-delay="<?php echo get_row_index(); ?>00" data-aos="fade-up">
                                <?php if( $sections_left_attributes_ico ) { ?>
                                  <div class="product-attributes-ico">
                                    <img class="lazy" data-src="<?php echo $sections_left_attributes_ico; ?>" alt="" />
                                  </div>
                                <?php } ?>
                                <?php if( $sections_left_attributes_name ) { ?>
                                  <h3><?php echo $sections_left_attributes_name; ?></h3>
                                <?php } ?>
                                <?php if( $sections_left_attributes_description ) { ?>
                                  <h4><?php echo $sections_left_attributes_description; ?></h4>
                                <?php } ?>
                              </div>
                            </div>
                          <?php endwhile; ?>
                        </div>
                      <?php endif; ?>
                    <?php endif; ?>
                  <?php endwhile; ?>
                <?php endif; ?>
              </div>
            </div>
            <div class="col-12 col-md-6">
              <div class="product-right"> 
                <?php if( have_rows('sections_right_section') ): ?>
                  <?php while ( have_rows('sections_right_section') ) : the_row(); ?>
                    <?php if( get_row_layout() == 'sections_right_section_image' ): ?>
                      <?php
                        $sections_right_image=get_sub_field('sections_right_image');
                      ?>
                      <?php if( $sections_right_image ) { ?>
                        <div data-aos-delay="300" data-aos="fade-left"><img class="lazy product-img" data-src="<?php echo $sections_right_image; ?>" alt="" /></div>
                      <?php } ?>
                    <?php endif; ?>
                    <?php if( get_row_layout() == 'sections_right_section_content' ): ?>
                      <?php
                        $sections_right_content=get_sub_field('sections_right_content');
                      ?>
                      <?php if( $sections_right_content ) { ?>
                        <div class="product-content" data-aos-delay="300" data-aos="fade-left"><?php echo $sections_right_content; ?></div>
                      <?php } ?>
                    <?php endif; ?>
                    <?php if( get_row_layout() == 'sections_right_section_attributes' ): ?>
                      <?php if( have_rows('sections_right_attributes') ): ?>
                        <div class="row product-attributes">
                          <?php while ( have_rows('sections_right_attributes') ) : the_row(); ?>
                            <?php
                              $sections_right_attributes_ico=get_sub_field('sections_right_attributes_ico');
                              $sections_right_attributes_name=get_sub_field('sections_right_attributes_name');
                              $sections_right_attributes_description=get_sub_field('sections_right_attributes_description');
                            ?>
                            <div class="col-6 col-lg-4">
                              <div class="product-attributes-box" data-aos-delay="<?php echo get_row_index(); ?>00" data-aos="fade-up">
                                <?php if( $sections_right_attributes_ico ) { ?>
                                  <div class="product-attributes-ico">
                                    <img class="lazy" data-src="<?php echo $sections_right_attributes_ico; ?>" alt="" />
                                  </div>
                                <?php } ?>
                                <?php if( $sections_right_attributes_name ) { ?>
                                  <h3><?php echo $sections_right_attributes_name; ?></h3>
                                <?php } ?>
                                <?php if( $sections_right_attributes_description ) { ?>
                                  <h4><?php echo $sections_right_attributes_description; ?></h4>
                                <?php } ?>
                              </div>
                            </div>
                          <?php endwhile; ?>
                        </div>
                      <?php endif; ?>
                    <?php endif; ?>
                  <?php endwhile; ?>
                <?php endif; ?>
              </div>
            </div>
          </div>
        </div>
      </section>

    <?php endif; ?>

  <?php endwhile; ?>
<?php endif; ?>



<?php
  $ue_logos=get_field('ue_logos');
  $ue_info_1=get_field('ue_info_1');
  $ue_info_2=get_field('ue_info_2');
?>

<?php if( $ue_logos || $ue_info_1 || $ue_info_2 ) { ?>
  <section class="ue" data-aos-delay="300" data-aos="fade-up">
    <div class="container">
      <div class="row">
        <div class="col-12 col-md-6">
          <div class="product-left">
            <?php if( $ue_logos ) { ?>
              <img class="lazy" data-src="<?php echo $ue_logos; ?>" alt="" />
            <?php } ?>
            <?php if( $ue_info_1 || $ue_info_2 ) { ?>
              <div class="ue-box">
                <?php if( $ue_info_1 ) { ?>
                  <h3><?php echo $ue_info_1; ?></h3>
                <?php } ?>
                <?php if( $ue_info_2 ) { ?>
                  <h4><?php echo $ue_info_2; ?></h4>
                <?php } ?>
              </div>
            <?php } ?>
          </div>
        </div>
      </div>
    </div>
  </section>
<?php } ?>

<?php get_footer(); ?>
