
<?php get_header(); ?>

<?php
  $contact_header=get_field('contact_header');
  $contact_content=get_field('contact_content');
?>

<div class="container-fluid contact">
  <div class="row">
    <div class="col-12 col-md-6">
      <iframe class="contact-map" data-aos="fade-right" src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2491.1469240856186!2d17.472010815967995!3d51.36359562902808!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x470fff0a04e5704f%3A0x84d4650e1d7a9c4d!2sD%C5%82uga%202%2C%2056-416%20Twardog%C3%B3ra!5e0!3m2!1spl!2spl!4v1630933428641!5m2!1spl!2spl" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
    </div>
    <div class="col-12 col-md-6">
      <div class="contact-form" data-aos="fade-left">
        <h2><?php the_title(); ?></h2>
        <?php if( $contact_header ) { ?>
          <h3><?php echo $contact_header; ?></h3>
        <?php } ?>

        <?php 
          if(ICL_LANGUAGE_CODE=='en') {
            echo do_shortcode("[contact-form-7 id='450' title='Formularz - kontakt']");
          } elseif(ICL_LANGUAGE_CODE=='de') {
            echo do_shortcode("[contact-form-7 id='451' title='Formularz - kontakt']");
          } else {
            echo do_shortcode("[contact-form-7 id='107' title='Formularz - kontakt']");
          }    
        ?>

      </div>
    </div>
  </div>
</div>

<div class="contact-details-bg">
  <div class="container">
    <div class="row">
      <div class="col-12 col-md-6 contact-details">
        <?php
          if( get_field('contact_details') ) {
        ?>
          <?php
            while( the_repeater_field('contact_details') ) {
              $contact_details_header=get_sub_field('contact_details_header');
              $contact_details_content=get_sub_field('contact_details_content');
          ?>
            <div class="contact-details-b" data-aos-delay="<?php echo get_row_index(); ?>00" data-aos="fade-top">
              <?php if( $contact_details_header ) { ?>
                <h3><?php echo $contact_details_header; ?></h3>
              <?php } ?>
              <?php echo $contact_details_content; ?>
            </div>
          <?php
            }
          ?>
        <?php
          }
          wp_reset_postdata();
        ?>
      </div>
      <div class="col-12 col-md-6">
        <div class="contact-quote" data-aos-delay="300" data-aos="fade-left">
          <img class="lazy" data-src="<?php echo get_template_directory_uri() ?>/images/contact-q.png" alt="" />
          <?php if( $contact_content ) { ?>
            <p><?php echo $contact_content; ?></p>
          <?php } ?>
        </div>
      </div>
    </div>
  </div>
</div>


<?php get_footer(); ?>
